-- =============================================
-- E-Kitap Platform - Veritabanı Import Dosyası
-- phpMyAdmin'den direkt import edilebilir
-- Veritabanı: nwbsjtjv_ekitapp
-- Domain: ekitap.2w.tr
-- =============================================

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+03:00";
SET NAMES utf8mb4;

-- ──────────────────────────────────────
-- Tablo: users
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `users` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `email` VARCHAR(255) NOT NULL,
    `password_hash` VARCHAR(255) NOT NULL,
    `name` VARCHAR(150) NOT NULL DEFAULT '',
    `locale` VARCHAR(5) NOT NULL DEFAULT 'tr',
    `avatar_url` VARCHAR(500) NULL,
    `is_active` TINYINT(1) NOT NULL DEFAULT 1,
    `last_login_at` DATETIME NULL,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `uk_users_email` (`email`),
    KEY `idx_users_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: roles
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `roles` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `name` VARCHAR(50) NOT NULL,
    `description` VARCHAR(255) NULL,
    UNIQUE KEY `uk_roles_name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: user_roles
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `user_roles` (
    `user_id` INT UNSIGNED NOT NULL,
    `role_id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`user_id`, `role_id`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`role_id`) REFERENCES `roles`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: categories
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `categories` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `slug` VARCHAR(100) NOT NULL,
    `icon` VARCHAR(50) NULL,
    `sort_order` INT NOT NULL DEFAULT 0,
    `is_active` TINYINT(1) NOT NULL DEFAULT 1,
    UNIQUE KEY `uk_categories_slug` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: category_translations
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `category_translations` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `category_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL,
    `name` VARCHAR(200) NOT NULL,
    UNIQUE KEY `uk_cat_trans` (`category_id`, `lang`),
    FOREIGN KEY (`category_id`) REFERENCES `categories`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: books
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `books` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `slug` VARCHAR(200) NOT NULL,
    `category_id` INT UNSIGNED NULL,
    `status` ENUM('draft','published','hidden') NOT NULL DEFAULT 'draft',
    `is_free` TINYINT(1) NOT NULL DEFAULT 0,
    `preview_pages` INT NOT NULL DEFAULT 10,
    `default_lang` VARCHAR(5) NOT NULL DEFAULT 'tr',
    `cover_path` VARCHAR(500) NULL,
    `total_pages` INT NOT NULL DEFAULT 0,
    `sort_order` INT NOT NULL DEFAULT 0,
    `view_count` INT UNSIGNED NOT NULL DEFAULT 0,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `uk_books_slug` (`slug`),
    KEY `idx_books_status` (`status`),
    KEY `idx_books_category` (`category_id`),
    KEY `idx_books_free` (`is_free`),
    FOREIGN KEY (`category_id`) REFERENCES `categories`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: book_translations
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `book_translations` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `book_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL,
    `title` VARCHAR(500) NOT NULL,
    `description` TEXT NULL,
    `author` VARCHAR(300) NULL,
    `publisher` VARCHAR(300) NULL,
    `isbn` VARCHAR(20) NULL,
    `seo_title` VARCHAR(200) NULL,
    `seo_desc` VARCHAR(500) NULL,
    `tags` VARCHAR(500) NULL COMMENT 'Virgülle ayrılmış etiketler',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `uk_book_trans` (`book_id`, `lang`),
    KEY `idx_book_trans_lang` (`lang`),
    FULLTEXT KEY `ft_book_search` (`title`, `description`, `author`, `tags`),
    FOREIGN KEY (`book_id`) REFERENCES `books`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: book_assets
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `book_assets` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `book_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL,
    `format` ENUM('chunk','epub','pdf') NOT NULL,
    `version` INT NOT NULL DEFAULT 1,
    `path` VARCHAR(500) NOT NULL COMMENT 'Dosya veya base dizin yolu',
    `preview_path` VARCHAR(500) NULL COMMENT 'EPUB/PDF preview dosyası',
    `is_active` TINYINT(1) NOT NULL DEFAULT 1,
    `size_bytes` BIGINT UNSIGNED NULL,
    `checksum` VARCHAR(64) NULL COMMENT 'SHA-256 hash',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY `idx_book_assets` (`book_id`, `lang`, `format`, `is_active`),
    FOREIGN KEY (`book_id`) REFERENCES `books`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: book_chunk_index
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `book_chunk_index` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `book_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL,
    `version` INT NOT NULL DEFAULT 1,
    `chunk_no` INT NOT NULL,
    `page_start` INT NOT NULL,
    `page_end` INT NOT NULL,
    `file_path` VARCHAR(500) NOT NULL,
    UNIQUE KEY `uk_chunk` (`book_id`, `lang`, `version`, `chunk_no`),
    KEY `idx_chunk_pages` (`book_id`, `lang`, `version`, `page_start`, `page_end`),
    FOREIGN KEY (`book_id`) REFERENCES `books`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: subscriptions
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `subscriptions` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT UNSIGNED NOT NULL,
    `provider` VARCHAR(30) NOT NULL DEFAULT 'google_play',
    `product_id` VARCHAR(100) NOT NULL,
    `order_id` VARCHAR(200) NULL,
    `purchase_token_hash` VARCHAR(64) NOT NULL COMMENT 'SHA-256 hash',
    `is_active` TINYINT(1) NOT NULL DEFAULT 0,
    `starts_at` DATETIME NULL,
    `expiry_time` DATETIME NULL,
    `auto_renewing` TINYINT(1) NOT NULL DEFAULT 0,
    `cancel_reason` VARCHAR(50) NULL,
    `last_verified_at` DATETIME NULL,
    `raw_response` JSON NULL COMMENT 'Son doğrulama yanıtı',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    KEY `idx_sub_user` (`user_id`, `is_active`),
    KEY `idx_sub_expiry` (`expiry_time`),
    KEY `idx_sub_token` (`purchase_token_hash`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: reading_progress
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `reading_progress` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT UNSIGNED NOT NULL,
    `book_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL DEFAULT 'tr',
    `last_format` ENUM('chunk','epub','pdf') NOT NULL DEFAULT 'chunk',
    `last_page` INT NOT NULL DEFAULT 0,
    `last_location` TEXT NULL COMMENT 'EPUB CFI veya PDF offset',
    `progress_percent` DECIMAL(5,2) NOT NULL DEFAULT 0.00,
    `total_reading_time` INT UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Saniye cinsinden',
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `uk_progress` (`user_id`, `book_id`, `lang`),
    KEY `idx_progress_user` (`user_id`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`book_id`) REFERENCES `books`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: bookmarks
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `bookmarks` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT UNSIGNED NOT NULL,
    `book_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL DEFAULT 'tr',
    `page` INT NULL,
    `location` TEXT NULL,
    `label` VARCHAR(300) NULL,
    `color` VARCHAR(20) NULL DEFAULT '#FFD700',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY `idx_bm_user_book` (`user_id`, `book_id`, `lang`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`book_id`) REFERENCES `books`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: notes
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `notes` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT UNSIGNED NOT NULL,
    `book_id` INT UNSIGNED NOT NULL,
    `lang` VARCHAR(5) NOT NULL DEFAULT 'tr',
    `page` INT NULL,
    `location` TEXT NULL,
    `selected_text` TEXT NULL,
    `note_content` TEXT NULL,
    `highlight_color` VARCHAR(20) NULL DEFAULT '#FFFF00',
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    `updated_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    KEY `idx_notes_user_book` (`user_id`, `book_id`, `lang`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE,
    FOREIGN KEY (`book_id`) REFERENCES `books`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: refresh_tokens
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `refresh_tokens` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT UNSIGNED NOT NULL,
    `token_hash` VARCHAR(64) NOT NULL,
    `expires_at` DATETIME NOT NULL,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY `uk_refresh_token` (`token_hash`),
    KEY `idx_refresh_user` (`user_id`),
    KEY `idx_refresh_expires` (`expires_at`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ──────────────────────────────────────
-- Tablo: subscription_logs
-- ──────────────────────────────────────
CREATE TABLE IF NOT EXISTS `subscription_logs` (
    `id` INT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` INT UNSIGNED NULL,
    `action` VARCHAR(50) NOT NULL,
    `product_id` VARCHAR(100) NULL,
    `status` VARCHAR(30) NULL,
    `details` JSON NULL,
    `ip_address` VARCHAR(45) NULL,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    KEY `idx_sub_log_user` (`user_id`),
    KEY `idx_sub_log_date` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ══════════════════════════════════════
-- SEED DATA - Başlangıç Verileri
-- ══════════════════════════════════════

-- Roller
INSERT INTO `roles` (`name`, `description`) VALUES
('superAdmin', 'Tam yetki - sistem yöneticisi'),
('admin', 'İçerik ve kullanıcı yönetimi'),
('editor', 'İçerik düzenleme'),
('translator', 'Çeviri yönetimi'),
('support', 'Destek ekibi');

-- Admin kullanıcı (Email: admin@ekitap.com / Şifre: Admin123!)
-- NOT: Bu hash çalışmazsa, cPanel Terminal'de şu komutu çalıştırın:
-- php -r "echo password_hash('Admin123!', PASSWORD_BCRYPT);"
-- ve çıkan değeri aşağıdaki hash ile değiştirin
INSERT INTO `users` (`email`, `password_hash`, `name`, `locale`) VALUES
('admin@ekitap.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin', 'tr');

-- Admin kullanıcıya superAdmin rolü ata
INSERT INTO `user_roles` (`user_id`, `role_id`) VALUES
(1, 1);

-- Kategoriler
INSERT INTO `categories` (`slug`, `icon`, `sort_order`) VALUES
('roman', 'book', 0),
('bilim', 'science', 1),
('tarih', 'history', 2),
('felsefe', 'psychology', 3),
('kisisel-gelisim', 'trending_up', 4),
('teknoloji', 'computer', 5),
('cocuk', 'child_care', 6),
('edebiyat', 'menu_book', 7);

-- Kategori çevirileri (8 dil)
INSERT INTO `category_translations` (`category_id`, `lang`, `name`) VALUES
-- Roman
(1, 'tr', 'Roman'), (1, 'en', 'Novel'), (1, 'de', 'Roman'), (1, 'es', 'Novela'),
(1, 'fr', 'Roman'), (1, 'it', 'Romanzo'), (1, 'pt', 'Romance'), (1, 'ar', 'رواية'),
-- Bilim
(2, 'tr', 'Bilim'), (2, 'en', 'Science'), (2, 'de', 'Wissenschaft'), (2, 'es', 'Ciencia'),
(2, 'fr', 'Science'), (2, 'it', 'Scienza'), (2, 'pt', 'Ciência'), (2, 'ar', 'علم'),
-- Tarih
(3, 'tr', 'Tarih'), (3, 'en', 'History'), (3, 'de', 'Geschichte'), (3, 'es', 'Historia'),
(3, 'fr', 'Histoire'), (3, 'it', 'Storia'), (3, 'pt', 'História'), (3, 'ar', 'تاريخ'),
-- Felsefe
(4, 'tr', 'Felsefe'), (4, 'en', 'Philosophy'), (4, 'de', 'Philosophie'), (4, 'es', 'Filosofía'),
(4, 'fr', 'Philosophie'), (4, 'it', 'Filosofia'), (4, 'pt', 'Filosofia'), (4, 'ar', 'فلسفة'),
-- Kişisel Gelişim
(5, 'tr', 'Kişisel Gelişim'), (5, 'en', 'Self-Help'), (5, 'de', 'Persönliche Entwicklung'), (5, 'es', 'Autoayuda'),
(5, 'fr', 'Développement personnel'), (5, 'it', 'Crescita personale'), (5, 'pt', 'Autoajuda'), (5, 'ar', 'تطوير الذات'),
-- Teknoloji
(6, 'tr', 'Teknoloji'), (6, 'en', 'Technology'), (6, 'de', 'Technologie'), (6, 'es', 'Tecnología'),
(6, 'fr', 'Technologie'), (6, 'it', 'Tecnologia'), (6, 'pt', 'Tecnologia'), (6, 'ar', 'تكنولوجيا'),
-- Çocuk
(7, 'tr', 'Çocuk'), (7, 'en', 'Children'), (7, 'de', 'Kinder'), (7, 'es', 'Niños'),
(7, 'fr', 'Enfants'), (7, 'it', 'Bambini'), (7, 'pt', 'Crianças'), (7, 'ar', 'أطفال'),
-- Edebiyat
(8, 'tr', 'Edebiyat'), (8, 'en', 'Literature'), (8, 'de', 'Literatur'), (8, 'es', 'Literatura'),
(8, 'fr', 'Littérature'), (8, 'it', 'Letteratura'), (8, 'pt', 'Literatura'), (8, 'ar', 'أدب');

COMMIT;
