<?php
/**
 * Admin Kullanıcı Kurulum Scripti
 * SQL import'tan sonra cPanel Terminal'de çalıştırın:
 * php /home/USERNAME/public_html/backend/migrations/admin_setup.php
 *
 * Bu script admin kullanıcısının şifresini doğru bcrypt hash ile oluşturur.
 */

// .env yükle
$backendDir = dirname(__DIR__);
$envFile = $backendDir . '/.env';
if (file_exists($envFile)) {
    $lines = file($envFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    foreach ($lines as $line) {
        if (str_starts_with(trim($line), '#')) continue;
        if (strpos($line, '=') === false) continue;
        [$key, $value] = explode('=', $line, 2);
        putenv(trim($key) . '=' . trim($value));
    }
}

$dbConfig = require $backendDir . '/config/database.php';

try {
    $dsn = "mysql:host={$dbConfig['host']};dbname={$dbConfig['dbname']};charset={$dbConfig['charset']}";
    $pdo = new PDO($dsn, $dbConfig['username'], $dbConfig['password'], $dbConfig['options']);

    // Admin şifresini doğru hash ile güncelle
    $adminEmail = 'admin@ekitap.com';
    $adminPass = password_hash('Admin123!', PASSWORD_BCRYPT);

    $stmt = $pdo->prepare("UPDATE users SET password_hash = ? WHERE email = ?");
    $stmt->execute([$adminPass, $adminEmail]);

    if ($stmt->rowCount() > 0) {
        echo "✓ Admin şifresi başarıyla güncellendi!\n";
    } else {
        echo "⚠ Admin kullanıcı bulunamadı, oluşturuluyor...\n";

        $stmt = $pdo->prepare("INSERT INTO users (email, password_hash, name, locale) VALUES (?, ?, ?, ?)");
        $stmt->execute([$adminEmail, $adminPass, 'Admin', 'tr']);
        $userId = $pdo->lastInsertId();

        $roleId = $pdo->query("SELECT id FROM roles WHERE name = 'superAdmin'")->fetchColumn();
        if ($roleId) {
            $pdo->prepare("INSERT IGNORE INTO user_roles (user_id, role_id) VALUES (?, ?)")
                ->execute([$userId, $roleId]);
        }

        echo "✓ Admin kullanıcı oluşturuldu!\n";
    }

    echo "\n══════════════════════════════\n";
    echo "Admin Giriş Bilgileri:\n";
    echo "Email: admin@ekitap.com\n";
    echo "Şifre: Admin123!\n";
    echo "══════════════════════════════\n";
    echo "\n⚠ ÖNEMLİ: İlk girişte şifreyi değiştirin!\n";

} catch (PDOException $e) {
    echo "❌ Hata: " . $e->getMessage() . "\n";
    exit(1);
}
