<?php
/**
 * Rate Limit Middleware - IP bazlı
 * Basit dosya tabanlı (cPanel uyumlu, Redis gerektirmez)
 */
class RateLimitMiddleware
{
    public function handle(): bool
    {
        $config = require __DIR__ . '/../config/app.php';
        $limit = $config['rate_limit']['requests_per_minute'];

        $ip = Request::ip();
        $key = md5($ip);
        $dir = sys_get_temp_dir() . '/ekitap_ratelimit';

        if (!is_dir($dir)) {
            @mkdir($dir, 0755, true);
        }

        $file = "$dir/$key.json";
        $now = time();
        $windowStart = $now - 60;

        $data = ['requests' => []];
        if (file_exists($file)) {
            $data = json_decode(file_get_contents($file), true) ?? ['requests' => []];
        }

        // Eski kayıtları temizle (60 saniye penceresi)
        $data['requests'] = array_filter($data['requests'], fn($t) => $t > $windowStart);

        if (count($data['requests']) >= $limit) {
            header('Retry-After: 60');
            Response::error(
                'Çok fazla istek gönderdiniz. Lütfen bekleyin.',
                'RATE_LIMIT_EXCEEDED',
                429
            );
            return false;
        }

        $data['requests'][] = $now;
        file_put_contents($file, json_encode($data));

        return true;
    }
}
