# E-Kitap Backend API

Modern, ölçeklenebilir e-kitap platformu backend sistemi. PHP 8.x, MySQL/MariaDB ve cPanel uyumlu.

## 🚀 Özellikler

### ✅ Tamamlanan Özellikler

- **Kimlik Doğrulama**: JWT tabanlı auth sistemi (access + refresh token)
- **Kullanıcı Yönetimi**: Roller ve yetkiler (superAdmin, admin, editor, translator, support)
- **Kitap Yönetimi**: CRUD işlemleri, çoklu dil desteği (8 dil)
- **Çok Format Desteği**: Chunk (JSON), EPUB, PDF
- **Erişim Kontrolü**: Free, preview, subscription tabanlı paywall
- **Google Play Abonelik**: Satın alma doğrulama ve periyodik yenileme
- **İlerleme Takibi**: Sayfa, lokasyon, yüzde bazlı
- **Yer İmleri & Notlar**: Kullanıcı annotations
- **Admin Panel**: Modern, dark mode destekli web UI
- **Güvenlik**: Rate limiting, CORS, security headers
- **Cron Jobs**: Otomatik abonelik yenileme

## 📋 Gereksinimler

- PHP 8.0 veya üzeri
- MySQL 5.7+ veya MariaDB 10.3+
- Apache 2.4+ (mod_rewrite, mod_headers)
- cPanel (opsiyonel, alternatif hosting de çalışır)
- Composer (opsiyonel, harici paket yok)

## 🛠️ Kurulum

### 1. Dosyaları Yükle

cPanel File Manager veya FTP ile tüm dosyaları sunucuya yükleyin:

```
/home/username/public_html/
├── backend/
│   ├── api/
│   ├── admin/
│   ├── config/
│   ├── controllers/
│   ├── core/
│   ├── cron/
│   ├── middleware/
│   ├── migrations/
│   └── routes/
└── storage/
```

### 2. Veritabanı Oluştur

cPanel > MySQL Databases:
1. Yeni veritabanı oluştur: `username_ekitap`
2. Yeni kullanıcı oluştur ve veritabanına ekle
3. Tüm yetkiler ver

### 3. Konfigürasyon

`backend/config/database.php` düzenle:

```php
return [
    'host'     => 'localhost',
    'dbname'   => 'username_ekitap',
    'username' => 'username_ekitapuser',
    'password' => 'güçlü_şifre',
    // ...
];
```

`backend/config/app.php` düzenle:

```php
return [
    'base_url'    => 'https://yourdomain.com',
    'jwt' => [
        'secret' => 'BURAYA_RANDOM_64_KARAKTER_GÜVENLI_KEY',
    ],
    'google_play' => [
        'package_name' => 'com.yourapp.ekitap',
    ],
    // ...
];
```

### 4. Migration Çalıştır

SSH veya cPanel Terminal:

```bash
cd /home/username/public_html/backend/migrations
php 001_initial.php
```

Çıktı:
```
✓ Veritabanı 'username_ekitap' hazır.
✓ users tablosu oluşturuldu.
...
✓ Admin kullanıcı oluşturuldu (admin@ekitap.com / Admin123!).
✅ Migration tamamlandı!
```

### 5. Storage İzinleri

```bash
chmod 755 storage
chmod 755 storage/books
chmod 755 storage/covers
```

### 6. Google Play Service Account (Abonelikler için)

1. Google Cloud Console > Service Accounts
2. JSON key indir
3. `backend/config/google-service-account.json` olarak kaydet
4. İzinleri ayarla: `chmod 600 backend/config/google-service-account.json`

### 7. Cron Job Ayarla

cPanel > Cron Jobs:

```
Frequency: Once per day (00:00)
Command: /usr/bin/php /home/username/public_html/backend/cron/refresh_subscriptions.php
```

## 🔐 Varsayılan Admin Girişi

Admin Panel: `https://yourdomain.com/backend/admin/`

```
Email: admin@ekitap.com
Şifre: Admin123!
```

**ÖNEMLİ**: İlk girişte şifreyi değiştirin!

## 📡 API Endpoints

### Public Endpoints

```
POST   /api/auth/register        - Kayıt ol
POST   /api/auth/login           - Giriş yap
POST   /api/auth/refresh         - Token yenile
GET    /api/books                - Kitap listesi
GET    /api/books/{slug}         - Kitap detay
```

### Authenticated Endpoints

```
POST   /api/auth/logout          - Çıkış yap
GET    /api/me                   - Kullanıcı bilgisi
GET    /api/books/{id}/access    - Kitap erişim bilgisi
GET    /api/books/{id}/chunks    - Chunk index
GET    /api/books/{id}/chunk/{no} - Chunk içerik
GET    /api/books/{id}/download  - EPUB/PDF indir
POST   /api/subscription/verify  - Abonelik doğrula
GET    /api/me/entitlement       - Erişim hakları
POST   /api/progress/update      - İlerleme kaydet
GET    /api/progress             - İlerleme getir
GET    /api/bookmarks            - Yer imleri
POST   /api/bookmarks            - Yer imi ekle
DELETE /api/bookmarks/{id}       - Yer imi sil
```

### Admin Endpoints

```
GET    /api/admin/dashboard           - Dashboard stats
GET    /api/admin/books               - Kitap listesi
POST   /api/admin/books               - Kitap ekle
PUT    /api/admin/books/{id}          - Kitap güncelle
DELETE /api/admin/books/{id}          - Kitap sil
POST   /api/admin/books/{id}/assets/upload - Dosya yükle
POST   /api/admin/books/{id}/chunks/upload - Chunk yükle
GET    /api/admin/users               - Kullanıcı listesi
PUT    /api/admin/users/{id}/roles    - Rol güncelle
GET    /api/admin/reports/subscriptions - Abonelik raporu
GET    /api/admin/reports/popular-books - Popüler kitaplar
```

## 📚 Kitap Ekleme (Admin)

### 1. Kitap Oluştur

Admin Panel > Kitaplar > Yeni Kitap

- Slug: `ornek-kitap`
- Başlık: Örnek Kitap
- Durum: published
- Ücretsiz: Hayır
- Preview Sayfalar: 10

### 2. Chunk Formatı Hazırla

Her chunk 10-30 sayfa içermeli. Örnek `chunk_001.json`:

```json
{
  "bookId": 1,
  "lang": "tr",
  "version": 1,
  "chunkNo": 1,
  "pageStart": 1,
  "pageEnd": 20,
  "pages": [
    {
      "pageNo": 1,
      "blocks": [
        {"type": "h1", "text": "Bölüm 1"},
        {"type": "p", "text": "Paragraf metni..."}
      ]
    }
  ]
}
```

### 3. Dosyaları Yükle

Admin Panel > Kitap Detay > Assets

**Chunk Yükle**:
- Files: chunk_001.json, chunk_002.json, ...
- Lang: tr
- Version: 1

**EPUB/PDF Yükle**:
- Full File: book_full.epub
- Preview File: book_preview.epub
- Lang: tr

## 🔒 Güvenlik

### Production Checklist

- [ ] JWT secret değiştir (64+ karakter random)
- [ ] Admin şifresini değiştir
- [ ] Database credentials güvenli
- [ ] `app.php` içinde `debug => false`
- [ ] HTTPS etkin
- [ ] Google service account JSON izinleri 600
- [ ] Rate limiting aktif
- [ ] CORS ayarları production domain'e göre

### Güvenlik Headers

`.htaccess` otomatik ekler:
- X-Content-Type-Options
- X-Frame-Options
- X-XSS-Protection
- Content-Security-Policy
- Referrer-Policy

## 🐛 Hata Ayıklama

### API 404 Hatası

.htaccess rewrite kuralları çalışmıyor olabilir:

```apache
# backend/api/.htaccess kontrol et
RewriteEngine On
RewriteBase /api/
```

cPanel > Apache Configuration > RewriteEngine: ON

### Database Bağlantı Hatası

```bash
# Test et
php -r "new PDO('mysql:host=localhost;dbname=test', 'user', 'pass');"
```

### Storage Erişim Hatası

```bash
# İzinleri kontrol et
ls -la storage/
chmod 755 storage/ -R
```

### Cron Çalışmıyor

```bash
# Manuel test
php /home/username/public_html/backend/cron/refresh_subscriptions.php
```

cPanel > Cron Jobs > Log kontrol et

## 📊 Veritabanı Şeması

### Ana Tablolar

- `users` - Kullanıcılar
- `roles` / `user_roles` - Roller ve yetkilendirme
- `books` - Kitap meta bilgileri
- `book_translations` - Çoklu dil çevirileri
- `book_assets` - Format dosyaları (chunk/epub/pdf)
- `book_chunk_index` - Chunk sayfa indeksi
- `subscriptions` - Google Play abonelikler
- `reading_progress` - Okuma ilerlemesi
- `bookmarks` / `notes` - Kullanıcı annotations
- `categories` - Kategoriler
- `subscription_logs` - Audit log

## 🚀 Performans

### Önbellekleme

HTTP cache headers otomatik ayarlanır:
- Covers: 7 gün
- Chunk index: 1 saat
- Chunk content: 1 gün

### Database İndeksler

Tüm kritik sorgular için indeks mevcut:
- `books(status, slug)`
- `book_assets(book_id, lang, format, is_active)`
- `subscriptions(user_id, is_active)`

### Rate Limiting

IP bazlı: 60 req/dakika (ayarlanabilir)

## 📞 Destek

Sorunlar için:
1. Log dosyalarını kontrol et
2. Browser console hataları
3. cPanel error logs
4. API response detayları

## 📝 Lisans

Bu proje özel bir e-kitap platformu için geliştirilmiştir.
